﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="default.aspx.cs" Inherits="TMSD4CJ._default" ClientIDMode="AutoID" %>

<%@ Register TagPrefix="sb" TagName="SearchBox" Src="~/Controls/SearchBox.ascx" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <meta name="TMS Directory For Cisco Jabber" content="" />
    <%--<link rel="icon" href="<%#HttpContext.Current.Request.Url.AbsoluteUri.Substring(0,HttpContext.Current.Request.Url.AbsoluteUri.LastIndexOf("/")) %>/favicon.ico" />--%>

    <title>Video Conferencing Directory</title>
    <!-- Bootstrap core CSS -->
    <link rel="stylesheet" type="text/css" href="./Content/bootstrap.min.css" />
    <link rel="stylesheet" type="text/css" href="./Content/TMSD4CJ.css" />

    <%--Include Jquery--%>
    <script src="./Scripts/jquery-1.9.1.min.js"></script>
    <script src="./Scripts/bootstrap.min.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <div class="container round grey2">
            <div class="row grey1 top-round">
                <div runat="server" class="col-md-12 min-padding">
                    <h3>
                        <asp:Label runat="server" ID="lbl_directoryTitle"></asp:Label></h3>
                    <%-- Include search box if needed --%>
                    <div runat="server" id="div_searchBox"><sb:SearchBox ID="SearchBox1" runat="server" /></div>
                </div>
            </div>
            <div class="row grey2">
                <div class="col-md-12" style="padding: 0px;">
                            <table runat="server" id="navigationMenu" visible="false" style="width:100%">
                                <tr>
                                <td runat="server" style="text-align: left; padding-left: 10px">
                                    <asp:LinkButton CommandName="NavigateHome" CommandArgument="Home" runat="server" ID="lbtn_home" OnClick="lbtn_home_Click">Home</asp:LinkButton>
                                </td>
                                <td></td>
                                <td runat="server" style="text-align: right; padding-right: 10px">
                                    <asp:LinkButton CommandName="NavigateBack" CommandArgument="Back" runat="server" ID="lbtn_back" OnClick="lbtn_back_Click">Back</asp:LinkButton>
                                </td>
                            </tr>
                            </table>
                            
                            <asp:ListView ID="lstView_TMSCatalogueEntries" runat="server" OnItemDataBound="lstView_TMSCatalogueEntries_ItemDataBound" OnDataBound="lstView_TMSCatalogueEntries_DataBound" OnDataBinding="lstView_TMSCatalogueEntries_DataBinding" OnItemCommand="lstView_TMSCatalogueEntries_ItemCommand" ViewStateMode="Enabled">

                                <LayoutTemplate>
                                    <table class="table table-hover">
                                        <tr id="ItemPlaceholder" runat="server"></tr>
                                    </table>

                                </LayoutTemplate>

                                <ItemTemplate>
                                    <tr>
                                        <td style="vertical-align: middle; width: 40px;">
                                            <asp:Label runat="server" ID="lbl_entryGlyphicon" Font-Size="1.5em"></asp:Label>
                                        </td>
                                        <td runat="server" id="td_entCatName" style="vertical-align: middle; text-align: left;">
                                            <asp:HyperLink runat="server" ID="lbtn_entCatName"></asp:HyperLink>
                                            <asp:Label runat="server" ID="lbl_entCatName" Visible="false"></asp:Label>
                                        </td>
                                        <td runat="server" id="td_callButton" width="62px" style="padding: 0px; vertical-align: middle;">
                                            <!-- Call button Div -->
                                            <div runat="server" id="testID" class="btn-group" style="border: 0px solid">
                                                <asp:LinkButton runat="server" id="btn_callButton" class="btn btn-success btn-sm" type="button"><span class="glyphicon glyphicon-earphone"></span></asp:LinkButton>

                                                <!-- Menu for multiple calling method -->
                                                <button runat="server" id="btn_callButtonMenu" type="button" class="btn btn-sm btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <span class="caret"></span>
                                                    <span class="sr-only">Toggle Dropdown</span>
                                                </button>

                                                <asp:ListView ID="lstView_entryCallingRoute" runat="server" OnItemDataBound="lstView_entryCallingRoute_ItemDataBound">

                                                    <LayoutTemplate>
                                                        <ul runat="server" id="btn_CallButtonEntry" class="dropdown-menu pull-right">
                                                            <li id="ItemPlaceholder2" runat="server"></li>
                                                        </ul>
                                                    </LayoutTemplate>
                                                    <ItemTemplate>
                                                        <li>
                                                            <asp:HyperLink runat="server" ID="hpl_route"></asp:HyperLink></li>
                                                    </ItemTemplate>

                                                    <EmptyDataTemplate></EmptyDataTemplate>
                                                </asp:ListView>
                                            </div>
                                        </td>
                                    </tr>
                                </ItemTemplate>

                                <EmptyDataTemplate>
                                    <p style="font-style: italic">No entry found.</p>
                                </EmptyDataTemplate>
                            </asp:ListView>


                            <%--Error Message Box--%>
                            <div runat="server" id="errorMessageDiv" class="alert alert-danger hidden" role="alert">
                                <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
                                <span class="sr-only">Error:</span>
                                <asp:Label ID="lbl_errorMesage" runat="server" Text=""></asp:Label>
                            </div>
                            </div>
                      <%--  </ContentTemplate>
                    </asp:UpdatePanel>--%>

                </div>
                <div id="divDemoBanner" runat="server"><span style="font-size: 12px; color:red;">- <%=TMSD4CJ.TMSD4CJRsc.demoBanner%> -</span><br /></div>
                <span style="font-size: 9px;">- Copyright © 2018 <a target="_blank" href='http://www.quickonline.ch/tmsdirectory4jabber/'>QuickOnline</a> -</span>
            
        </div><%-- End container --%>
    </form>
</body>
</html>
